#version 130
//#extension GL_EXT_gpu_shader4 : enable
#extension GL_ARB_gpu_shader5 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// 2D Adventures #2 - Hex GridMod01.fsh  by   bombshell93  
//https://www.shadertoy.com/view/XdKyDt
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//// ABSTRACT
//
//	The purpose of this was to understand hexagonal coordinate systems in the
//	context of a shader, the ease of understanding is thanks in no small part
//	to the redblobgames blog on the subject:
//		https://www.redblobgames.com/grids/hexagons/#distances
//
//	I'd expected this to take a bit more fiddling, but I also don't want to over
//	develop this shader, as its fulfilling its purpose, so I put in some mouse
//	interaction (click to see what I mean) for the fun of it.
//	
//
//// AUTHOR
//
//	Scott R Howell (bombshell93)

#define PI 3.14
#define PI2 6.28

#define HX vec2(1., 0.)
#define HY vec2(.5, 0.866)
#define HMAT mat2(HX, HY)
#define HSCALE 0.05

//// pixelToCubial
//
//	converts a pixel coordinate to a hex grid cubial coordinates

void pixelToCubial(vec2 uv, out vec3 cubial, out vec3 grid) {
    
    vec2 axial = inverse(HMAT) * uv;
    cubial = vec3(axial, -axial.x - axial.y) / HSCALE;
    grid = round(cubial);
    vec3 dist = abs(cubial - grid);
    if (dist.x > dist.y && dist.x > dist.z) {
    	
        grid.x = -grid.y - grid.z;
    }
    else if (dist.y > dist.z) {
        
        grid.y = -grid.x - grid.z;
    }
    else {
        
        grid.z = -grid.x - grid.y;
    }
}

//// cubialDistance
//
//	finds the distance between 2 hex cell positions

float cubialDistance(vec3 a, vec3 b) {
    
    vec3 c = abs(a - b);
    return max(c.x, max(c.y, c.z));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    
    vec2 uv = (fragCoord - iResolution.xy * .5) / iResolution.y;
    
    // find cubial coordinates
    
    vec3 cubial;
    vec3 grid;
    vec3 mouse;
    pixelToCubial((iMouse.xy - iResolution.xy * .5) / iResolution.y, cubial, mouse);
    pixelToCubial(uv, cubial, grid);
    
    
    // get per tile coordinates
    
    vec3 coord = cubial - grid;
    vec3 dist = abs(coord.xyz - coord.zxy);
    
    vec3 col = cos(grid + iTime) * .5 + .5;
    
    // outline
    
    col *= smoothstep(.2, .2 + (2.0 / iResolution.y) / HSCALE, 1.0 - max(dist.x, max(dist.y, dist.z)));
    
    // react to mouse input
    
    float mouseDist;
    if (iMouse.z > .0 && iMouse.w > .0 && (mouseDist = cubialDistance(grid, mouse)) < 4.) {
        
        float mouseDist = cubialDistance(grid, mouse);
    	col = mix(col, vec3(1.), max(.0, sin(mouseDist - iTime * 4.) * .5 + .5));
    }
    
    fragColor = vec4(col, 1.);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

